package com.bycom.versapro.MenuTypes.WebView;

import static com.bycom.versapro.Serializables.Constant.adMobHelper;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.bycom.versapro.Activities.MainActivity;
import com.bycom.versapro.R;
import com.bycom.versapro.Serializables.AppConfig;
import com.bycom.versapro.Serializables.Constant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressLint("SetJavaScriptEnabled")
@SuppressWarnings("SpellCheckingInspection")
public class WebViewFragment extends Fragment {


    String current_url = "";
    WebView webView;
    ValueCallback<Uri[]> mFilePathCallback;
    MainActivity mainActivity;
    FrameLayout fullscreenContainer;
    ActivityResultLauncher<Intent> filePickerLauncher = registerForActivityResult(
            new ActivityResultContracts.StartActivityForResult(),
            result -> {
                if (result.getResultCode() == Activity.RESULT_OK && result.getData()!=null)
                    mFilePathCallback.onReceiveValue(new Uri[]{Uri.parse(result.getData().getDataString())});
                else mFilePathCallback.onReceiveValue(new Uri[]{});
            }
    );


    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_web_view, container, false);
    }


    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);


        mainActivity = (MainActivity) requireActivity();

        Bundle bundle = getArguments();
        assert bundle != null;

        AppConfig.AppMenu menu = (AppConfig.AppMenu) bundle.getSerializable("appMenu");
        assert menu != null;


        webView = view.findViewById(R.id.webView);
        SwipeRefreshLayout swipeRefreshLayout = view.findViewById(R.id.swipeRefresh);



        swipeRefreshLayout.setOnRefreshListener(webView::reload);


        String customUserAgent = "Mozilla/5.0 (Linux; Android 13; Pixel 6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Mobile Safari/537.36";

        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setUserAgentString(customUserAgent);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setAllowFileAccess(true);
        webSettings.setAllowContentAccess(true);
        webSettings.setAllowFileAccessFromFileURLs(true);
        webSettings.setAllowUniversalAccessFromFileURLs(true);
        webSettings.setSupportZoom(true);
        webSettings.setGeolocationEnabled(true);
        webSettings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);



        if(!Constant.appConfig.app_settings.DynamicToolbarEnabled()){
            mainActivity.changeToolbarBackground(Color.parseColor(menu.toolbar_color),false);
        }else mainActivity.changeToolbarBackground(ContextCompat.getColor(mainActivity,R.color.background_color),false);


        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                mainActivity.customProgressBar.setProgress(newProgress);
                if (newProgress < 100)
                    mainActivity.customProgressBar.setVisibility(View.VISIBLE);
                else {
                    mainActivity.customProgressBar.setVisibility(View.GONE);

                    if(Constant.appConfig.app_settings.DynamicToolbarEnabled()){
                        if(!current_url.equals(webView.getUrl())){
                            current_url = webView.getUrl();
                            webView.setDrawingCacheEnabled(true);
                            Bitmap bitmap = Bitmap.createBitmap(webView.getDrawingCache());
                            webView.setDrawingCacheEnabled(false);
                            int color = bitmap.getPixel(bitmap.getWidth() / 2, 0);
                            bitmap.recycle();
                            mainActivity.changeToolbarBackground(color,true);
                        }
                    }

                }

            }




            @Override
            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
                mainActivity.getWindow().setFlags(
                        WindowManager.LayoutParams.FLAG_FULLSCREEN,
                        WindowManager.LayoutParams.FLAG_FULLSCREEN
                );

                mainActivity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);


                fullscreenContainer = new FrameLayout(mainActivity);
                fullscreenContainer.addView(view, new FrameLayout.LayoutParams(
                        ViewGroup.LayoutParams.MATCH_PARENT,
                        ViewGroup.LayoutParams.MATCH_PARENT
                ));

                ViewGroup decorView = (ViewGroup) mainActivity.getWindow().getDecorView();
                decorView.addView(fullscreenContainer);



            }

            @Override
            public void onHideCustomView() {

                ViewGroup decorView = (ViewGroup) mainActivity.getWindow().getDecorView();
                decorView.removeView(fullscreenContainer);

                fullscreenContainer = null;

                mainActivity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);
                mainActivity.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
            }

            @Override
            public boolean onShowFileChooser(
                    WebView webView, ValueCallback<Uri[]> filePathCallback,
                    FileChooserParams fileChooserParams
            ) {
                Intent intent = fileChooserParams.createIntent();
                filePickerLauncher.launch(intent);
                mFilePathCallback = filePathCallback;
                return true;
            }
        });

        webView.setDownloadListener((url, userAgent, contentDisposition, mimetype, contentLength) -> {
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
            CustomTabsIntent customTabsIntent = builder.build();
            customTabsIntent.launchUrl(requireContext(), Uri.parse(url));
        });

        webView.setWebViewClient(new WebViewClient() {

            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                swipeRefreshLayout.setRefreshing(false);

            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                adMobHelper.getInterstitialAdManager().showAd(mainActivity);
                Uri uri = request.getUrl();
                String scheme = uri.getScheme();
                if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                    view.loadUrl(uri.toString());
                }else if("intent".equalsIgnoreCase(scheme)){
                    try {
                        Intent intent = Intent.parseUri(uri.toString(), Intent.URI_INTENT_SCHEME);
                        startActivity(intent);
                    } catch (Exception e) {
                        String fragment = uri.getFragment();
                        if (fragment != null) {
                            Pattern pattern = Pattern.compile("S\\.browser_fallback_url=([^;]+)");
                            Matcher matcher = pattern.matcher(fragment);
                            if (matcher.find()) {
                                String browserFallbackUrl = matcher.group(1);
                                if(browserFallbackUrl!=null) view.loadUrl(browserFallbackUrl);
                            }
                        }
                    }
                }else intentUri(uri);
                return true;
            }
        });

        webView.loadUrl(menu.menu_data);





    }





    @Override
    public void onDestroy() {
        super.onDestroy();
        webView.destroy();
    }


    private void intentUri(Uri uri){
        try {
            Intent externalIntent = new Intent(Intent.ACTION_VIEW, uri);
            startActivity(externalIntent);
        }catch (Exception ignored){}
    }

    public void handleBackPress(){
        if (webView.canGoBack()) {
            webView.goBack();
        }else mainActivity.closeActivity();

    }




}